///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//  Copyright  NetworkDLS 2002, All rights reserved
//
// THIS CODE AND INFORMATION IS PROVIDED "AS IS" WITHOUT WARRANTY OF 
// ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO 
// THE IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A 
// PARTICULAR PURPOSE.
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#include <Windows.H>
#include <Stdio.H>    
#include <Stdlib.H> 
#include <String.H> 

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#include "Debug.H"
#include "../SharedSource/NSWFL.H"
#include "Common.H"

#include "../SharedClasses/LZARI/Compression.H"
#include "../SharedClasses/CMemPool/CMemPool.H"

#ifdef _SQLESERVER
	#include "../SQLEServer/Source/Routines.H"
#elif _SQLECLIENT
	#include "../SQLEClient/Source/Routines.H"
#else
	#error "You must define either _SQLESERVER or _SQLECLIENT"
#endif

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#define BUFFER_SIZE (1024 * 1024)
#define EXTRA_SIZE  (1024 * 1024)

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

int CompressFile(const char *sSource, const char *sTarget)
{
    HANDLE hfSource = NULL;
    HANDLE hfTarget = NULL;

    hfSource = CreateFile(
        sSource,
        GENERIC_READ,
        FILE_SHARE_READ,
        NULL,
        OPEN_EXISTING,
        FILE_ATTRIBUTE_NORMAL,
        NULL
    );

    if(hfSource == INVALID_HANDLE_VALUE)
    {
		char sMsg[2500];
		sprintf_s(sMsg, sizeof(sMsg), "LZARI::CompressFile-> Failed to open source file [%s]", sSource);
		WriteSysLogEx(sMsg, EVENT_ERROR);

        return 0;
    }

    hfTarget = CreateFile(
        sTarget,
        GENERIC_WRITE,
        0,
        NULL,
        CREATE_ALWAYS,
        FILE_ATTRIBUTE_NORMAL,
        NULL
    );

    if(hfSource == INVALID_HANDLE_VALUE)
    {
		char sMsg[2500];
		sprintf_s(sMsg, sizeof(sMsg), "LZARI::CompressFile-> Failed to open target file [%s]", sTarget);
		WriteSysLogEx(sMsg, EVENT_ERROR);

		CloseHandle(hfSource);
        return 0;
    }

    LZARI MyLZARI;

    MyLZARI.Initialize();

    DWORD BytesRead = 0;
    DWORD BytesWritted = 0;
    DWORD DeflSize = 0;

    char *SourceBuf = NULL;
    char *TargetBuf = NULL;

    SourceBuf = (char *) gMem.Allocate(BUFFER_SIZE + 1, sizeof(char));
	Assert(!SourceBuf, "Memory Allocation Error.");
    TargetBuf = (char *) gMem.Allocate((BUFFER_SIZE + EXTRA_SIZE) + 1, sizeof(char));
	Assert(!TargetBuf, "Memory Allocation Error.");

    do{
        ReadFile(hfSource, SourceBuf, BUFFER_SIZE, &BytesRead, NULL);

        DeflSize = (BUFFER_SIZE + EXTRA_SIZE);

        MyLZARI.Deflate(SourceBuf, TargetBuf, BytesRead, &DeflSize);
        //printf("%d Bytes to %d Bytes\n", BytesRead, DeflSize);

        WriteFile(hfTarget, &BytesRead, sizeof(DWORD), &BytesWritted, NULL);
        WriteFile(hfTarget, &DeflSize, sizeof(DWORD), &BytesWritted, NULL);
        WriteFile(hfTarget, TargetBuf, DeflSize, &BytesWritted, NULL);
    } while(BytesRead == BUFFER_SIZE);

    gMem.Free(SourceBuf);
    gMem.Free(TargetBuf);

    CloseHandle(hfSource);
    CloseHandle(hfTarget);

    return 0;
}

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

int DecompressFile(const char *sSource, const char *sTarget)
{
    HANDLE hfSource = NULL;
    HANDLE hfTarget = NULL;

    hfSource = CreateFile(
        sSource,
        GENERIC_READ,
        FILE_SHARE_READ,
        NULL,
        OPEN_EXISTING,
        FILE_ATTRIBUTE_NORMAL,
        NULL
    );

    if(hfSource == INVALID_HANDLE_VALUE)
    {
		char sMsg[2500];
		sprintf_s(sMsg, sizeof(sMsg), "LZARI::DecompressFile-> Failed to open source file [%s]", sSource);
		WriteSysLogEx(sMsg, EVENT_ERROR);
        return 0;
    }

    hfTarget = CreateFile(
        sTarget,
        GENERIC_WRITE,
        0,
        NULL,
        CREATE_ALWAYS,
        FILE_ATTRIBUTE_NORMAL,
        NULL
    );

    if(hfSource == INVALID_HANDLE_VALUE)
    {
		char sMsg[2500];
		sprintf_s(sMsg, sizeof(sMsg), "LZARI::DecompressFile-> Failed to open target file [%s]", sTarget);
		WriteSysLogEx(sMsg, EVENT_ERROR);
        CloseHandle(hfSource);
        return 0;
    }

    LZARI MyLZARI;

    MyLZARI.Initialize();

    char *SourceBuf = NULL;
    char *TargetBuf = NULL;

    SourceBuf = (char *) gMem.Allocate((BUFFER_SIZE + EXTRA_SIZE), sizeof(char));
	Assert(!SourceBuf, "Memory Allocation Error.");
    TargetBuf = (char *) gMem.Allocate((BUFFER_SIZE + EXTRA_SIZE), sizeof(char));
	Assert(!TargetBuf, "Memory Allocation Error.");

    DWORD OrigSize = 0;
    DWORD DeflSize = 0;
    DWORD InflSize = 0;
    DWORD BytesRead = 0;
    DWORD BytesWritted = 0;

    do{
        ReadFile(hfSource, &OrigSize, sizeof(DWORD), &BytesRead, NULL);
        ReadFile(hfSource, &DeflSize, sizeof(DWORD), &BytesRead, NULL);
        ReadFile(hfSource, SourceBuf, DeflSize, &BytesRead, NULL);

        InflSize = (BUFFER_SIZE + EXTRA_SIZE);

        MyLZARI.Inflate(SourceBuf, TargetBuf, OrigSize, &InflSize);
        //printf("%d Bytes to %d Bytes\n", DeflSize, InflSize);

        WriteFile(hfTarget, TargetBuf, InflSize, &BytesWritted, NULL);
    } while(OrigSize == BUFFER_SIZE);

    gMem.Free(SourceBuf);
    gMem.Free(TargetBuf);

    CloseHandle(hfSource);
    CloseHandle(hfTarget);

    return 0;
}

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
